/**************************************************************************
   
     					SOUND PLAY FOR 51MCU
  
               		COPYRIGHT (c)   2005 BY JJJ.
                       		--  ALL RIGHTS RESERVED  --
  
   File Name:       SoundPlay.h
   Author:          Jiang Jian Jun
   Created:         2005/5/16
   Modified:		NO
   Revision: 		1.0
  
*******************************************************************************/

/*˵**************************************************************************
 ״ʽ unsigned char code MusicName{ߣߣ...., 0,0};	ĩβ:0,0 ʾ(Important)

 λɣ
 		λǱʾ 1~7 ߸ 
 		ʮλǱʾڵ:1-2-3-;
 		λʾǷҪ: 0-1-
 
 λɣ 
 		λʾʱֵӦϵǣ 
 			|ֵ(n):  |0 |1 |2 |3 | 4 | 5 | 6 
 			|: |1 |2 |4 |8 |16 |32 |64 		=2^n
 		ʮλʾЧ(0-2):  0-ͨ1-2-
 		λǷλ: 0-޷㣬1-з

 ӳĸʽ
 		Play(,,˶,ٶ);
	|           : Ҫŵָ,β(0,0);
	|(0-11)       :	ָٸ;
	|˶(1-3)	  : 1:˶, 2:, 3:˶;
	|ٶ(1-12000):	ֵԽٶԽ;

***************************************************************************/
#ifndef __SOUNDPLAY_H_REVISION_FIRST__
#define __SOUNDPLAY_H_REVISION_FIRST__

//**************************************************************************

#define SYSTEM_OSC 		12000000	//徧Ƶ12000000HZ
#define SOUND_SPACE 	4/5 		//ͨĳȷ,//ÿ4
sbit    BeepIO    =   	P3^7;		//ܽ

unsigned int  code FreTab[12]  = { 262,277,294,311,330,349,369,392,415,440,466,494 }; //ԭʼƵʱ
unsigned char code SignTab[7]  = { 0,2,4,5,7,9,11 }; 								  //1~7Ƶʱеλ
unsigned char code LengthTab[7]= { 1,2,4,8,16,32,64 };						
unsigned char Sound_Temp_TH0,Sound_Temp_TL0;	//ʱֵݴ 
unsigned char Sound_Temp_TH1,Sound_Temp_TL1;	//ʱֵݴ
//**************************************************************************
void InitialSound(void)
{
	BeepIO = 0;
	Sound_Temp_TH1 = (65535-(1/1200)*SYSTEM_OSC)/256;	// TL1Ӧװĳֵ 	(10msĳװֵ)
	Sound_Temp_TL1 = (65535-(1/1200)*SYSTEM_OSC)%256;	// TH1Ӧװĳֵ 
	TH1 = Sound_Temp_TH1;
	TL1 = Sound_Temp_TL1;
	TMOD  |= 0x11;
	ET0    = 1;
	ET1	   = 0;
	TR0	   = 0;
	TR1    = 0;
	EA     = 1;
}

void BeepTimer0(void) interrupt 1	//ж
{
	BeepIO = !BeepIO;
	TH0    = Sound_Temp_TH0;
 	TL0    = Sound_Temp_TL0;
}
//**************************************************************************
void Play(unsigned char *Sound,unsigned char Signature,unsigned Octachord,unsigned int Speed)
{
	unsigned int NewFreTab[12];		//µƵʱ
	unsigned char i,j;
	unsigned int Point,LDiv,LDiv0,LDiv1,LDiv2,LDiv4,CurrentFre,Temp_T,SoundLength;
	unsigned char Tone,Length,SL,SH,SM,SLen,XG,FD;
	for(i=0;i<12;i++) 				// ݵż˶µƵʱ 
	{
		j = i + Signature;
		if(j > 11)
		{
			j = j-12;
			NewFreTab[i] = FreTab[j]*2;
		}
		else
			NewFreTab[i] = FreTab[j];

		if(Octachord == 1)
			NewFreTab[i]>>=2;
		else if(Octachord == 3)
			NewFreTab[i]<<=2;
	}									
	
	SoundLength = 0;
	while(Sound[SoundLength] != 0x00)	//
	{
		SoundLength+=2;
	}

	Point = 0;
	Tone   = Sound[Point];	
	Length = Sound[Point+1]; 			// һʱʱֵ
	
	LDiv0 = 12000/Speed;				// 1ĳ(10ms) 	
	LDiv4 = LDiv0/4; 					// 4ĳ 
	LDiv4 = LDiv4-LDiv4*SOUND_SPACE; 	// ͨ׼ 
	TR0	  = 0;
	TR1   = 1;
	while(Point < SoundLength)
	{
		SL=Tone%10; 								// 
		SM=Tone/10%10; 								//ߵ 
		SH=Tone/100; 								//Ƿ 
		CurrentFre = NewFreTab[SignTab[SL-1]+SH]; 	//ӦƵ 	
		if(SL!=0)
		{
			if (SM==1) CurrentFre >>= 2; 		// 
			if (SM==3) CurrentFre <<= 2; 		//
			Temp_T = 65536-(50000/CurrentFre)*10/(12000000/SYSTEM_OSC);//ֵ
			Sound_Temp_TH0 = Temp_T/256; 
			Sound_Temp_TL0 = Temp_T%256; 
			TH0 = Sound_Temp_TH0;  
			TL0 = Sound_Temp_TL0 + 12; //12ǶжʱĲ 
		}
		SLen=LengthTab[Length%10]; 	//Ǽ
		XG=Length/10%10; 			//(0ͨ12) 
		FD=Length/100;
		LDiv=LDiv0/SLen; 			//ĳ(ٸ10ms)
		if (FD==1) 
			LDiv=LDiv+LDiv/2;
		if(XG!=1)	
			if(XG==0) 				//ͨ೤ 
				if (SLen<=4)	
					LDiv1=LDiv-LDiv4;
				else
					LDiv1=LDiv*SOUND_SPACE;
			else
				LDiv1=LDiv/2; 		//೤ 
		else
			LDiv1=LDiv;
		if(SL==0) LDiv1=0;
			LDiv2=LDiv-LDiv1; 		//ĳ 
	  	if (SL!=0)
		{
			TR0=1;
			for(i=LDiv1;i>0;i--) 	//涨ȵ 
			{
				while(TF1==0);
				TH1 = Sound_Temp_TH1;
				TL1 = Sound_Temp_TL1;
				TF1=0;
			}
		}
		if(LDiv2!=0)
		{
			TR0=0; BeepIO=0;
			for(i=LDiv2;i>0;i--) 	//ļ
			{
				while(TF1==0);
				TH1 = Sound_Temp_TH1;
				TL1 = Sound_Temp_TL1;
				TF1=0;
			}
		}
		Point+=2; 
		Tone=Sound[Point];
		Length=Sound[Point+1];
	}
	BeepIO = 0;
}
//**************************************************************************
#endif